/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputSlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputTag;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public abstract class RecipeInputItem
extends AbstractRecipeInputItem {
    public static final AbstractRecipeInputItem EMPTY = new AbstractRecipeInputItem(){

        @Override
        protected ItemMatchResult matchItem(ItemStack item, AbstractRecipeInputItem root) {
            return new ItemMatchResult(item == null || item.getType().isAir(), this, item, 0);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public AbstractRecipeInputItem clone() {
            return this;
        }

        @Override
        public ItemStack getItemDisplay() {
            return new ItemStack(Material.AIR);
        }

        @Override
        public String toString() {
            return "EMPTY";
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof AbstractRecipeInputItem) {
                AbstractRecipeInputItem item = (AbstractRecipeInputItem)obj;
                return item.isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public JsonElement serialize(JsonSerializationContext context) {
            return new JsonPrimitive("minecraft:air");
        }
    };
    private int amount;
    private int durabilityCost = 0;

    public RecipeInputItem(int amount, int durabilityCost) {
        this.amount = amount;
        this.durabilityCost = durabilityCost;
    }

    public RecipeInputItem(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public void setDurabilityCost(int durabilityCost) {
        this.durabilityCost = durabilityCost;
    }

    @Override
    public abstract RecipeInputItem clone();

    public static AbstractRecipeInputItem fromString(String string) {
        if (string == null) {
            return EMPTY;
        }
        String[] split = string.split(":");
        if (split.length != 2) {
            return EMPTY;
        }
        String[] pipeSplit = split[1].split("\\|");
        String namespace = split[0];
        String id = pipeSplit[0];
        int amount = 1;
        if (pipeSplit.length > 1) {
            amount = Integer.parseInt(pipeSplit[1]);
        }
        if (namespace.startsWith("#")) {
            Optional<Tag<Material>> tag = RecipeUtils.tagFromString(namespace.substring(1), id);
            if (tag.isPresent()) {
                return new RecipeInputTag(tag.get(), amount);
            }
            return EMPTY;
        }
        if (namespace.equals("minecraft")) {
            Material mat = Material.matchMaterial((String)id);
            return mat == null ? EMPTY : new RecipeInputItemStack(mat, amount);
        }
        if (namespace.equals("slimefun")) {
            return new RecipeInputSlimefunItem(id.toUpperCase(), amount);
        }
        return EMPTY;
    }

    public static AbstractRecipeInputItem fromItemStack(@Nullable ItemStack item, int amount, int durabilityCost) {
        if (item == null || item.getType().isAir()) {
            return EMPTY;
        }
        if (item instanceof SlimefunItemStack) {
            SlimefunItemStack sfItem = (SlimefunItemStack)item;
            return new RecipeInputSlimefunItem(sfItem.getItemId(), amount, durabilityCost);
        }
        Optional<String> itemID = Slimefun.getItemDataService().getItemData(item);
        if (itemID.isPresent()) {
            return new RecipeInputSlimefunItem(itemID.get(), amount, durabilityCost);
        }
        return new RecipeInputItemStack(item, amount, durabilityCost);
    }

    public static AbstractRecipeInputItem fromItemStack(@Nullable ItemStack item, int amount) {
        return RecipeInputItem.fromItemStack(item, amount, 0);
    }

    public static AbstractRecipeInputItem fromItemStack(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return EMPTY;
        }
        return RecipeInputItem.fromItemStack(item, item.getAmount());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("amount=");
        builder.append(this.amount);
        if (this.durabilityCost != 0) {
            builder.append(", durabilityCost=");
            builder.append(this.durabilityCost);
        }
        return builder.toString();
    }

    @Override
    public boolean canUseShortSerialization() {
        return this.durabilityCost == 0;
    }
}

