/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeInputGroup
extends AbstractRecipeInputItem {
    List<AbstractRecipeInputItem> items;

    public RecipeInputGroup(List<AbstractRecipeInputItem> items) {
        this.items = items;
    }

    public RecipeInputGroup(AbstractRecipeInputItem ... items) {
        this.items = List.of(items);
    }

    public List<AbstractRecipeInputItem> getItems() {
        return this.items;
    }

    public void setItems(List<AbstractRecipeInputItem> items) {
        this.items = items;
    }

    @Override
    public ItemMatchResult matchItem(ItemStack item, AbstractRecipeInputItem root) {
        for (AbstractRecipeInputItem i : this.items) {
            ItemMatchResult result = i.matchItem(item, root);
            if (!result.itemsMatch()) continue;
            return result;
        }
        return new ItemMatchResult(false, root, item, 0);
    }

    @Override
    public ItemStack getItemDisplay() {
        if (this.items.size() == 0) {
            return new ItemStack(Material.AIR);
        }
        return this.items.get(0).getItemDisplay();
    }

    @Override
    public boolean isEmpty() {
        return this.items.size() == 0 || this.items.stream().allMatch(i -> i.isEmpty());
    }

    @Override
    public RecipeInputGroup clone() {
        ArrayList<AbstractRecipeInputItem> items = new ArrayList<AbstractRecipeInputItem>();
        for (AbstractRecipeInputItem item : this.items) {
            items.add(item.clone());
        }
        return new RecipeInputGroup(items);
    }

    @Override
    public String toString() {
        return "RIGroup { " + String.valueOf(this.items) + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeInputGroup item = (RecipeInputGroup)obj;
        if (item.items.size() != this.items.size()) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (item.items.get(i).equals(this.items.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject group = new JsonObject();
        JsonArray arr = new JsonArray(this.items.size());
        for (AbstractRecipeInputItem item : this.items) {
            arr.add(context.serialize((Object)item, AbstractRecipeInputItem.class));
        }
        group.add("group", (JsonElement)arr);
        return group;
    }
}

