/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RecipeOutput
extends AbstractRecipeOutput {
    public static final AbstractRecipeOutput EMPTY = new AbstractRecipeOutput(){

        @Override
        public AbstractRecipeOutput.Inserter checkSpace(RecipeMatchResult result, Inventory inventory, int[] outputSlots) {
            return new AbstractRecipeOutput.Inserter(inventory);
        }

        @Override
        public List<ItemStack> generateOutput(RecipeMatchResult result) {
            return List.of();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public String toString() {
            return "Empty Recipe Output";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public JsonElement serialize(JsonSerializationContext context) {
            return new JsonObject();
        }
    };
    private List<AbstractRecipeOutputItem> items;

    public RecipeOutput(List<AbstractRecipeOutputItem> items) {
        this.items = items;
    }

    public static RecipeOutput fromItemStacks(ItemStack[] items) {
        return new RecipeOutput(Arrays.stream(items).map(item -> RecipeOutputItem.fromItemStack(item)).toList());
    }

    public List<AbstractRecipeOutputItem> getItems() {
        return this.items;
    }

    public AbstractRecipeOutputItem getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public List<ItemStack> generateOutput(RecipeMatchResult result) {
        return this.items.stream().map(i -> i.generateOutput(result)).toList();
    }

    @Override
    public AbstractRecipeOutput.Inserter checkSpace(RecipeMatchResult result, Inventory inventory, int[] outputSlots) {
        LinkedList<Integer> freeSlots = new LinkedList<Integer>();
        ArrayList<Integer> filledSlots = new ArrayList<Integer>();
        for (int i : outputSlots) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType().isAir()) {
                freeSlots.add(i);
                continue;
            }
            filledSlots.add(i);
        }
        HashMap<Integer, Integer> addToStacks = new HashMap<Integer, Integer>();
        HashMap<Integer, ItemStack> newStacks = new HashMap<Integer, ItemStack>();
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (AbstractRecipeOutputItem output : this.items) {
            ItemStack outputStack = output.generateOutput(result);
            if (output.getSpaceRequirement() == AbstractRecipeOutputItem.SpaceRequirement.EMPTY_SLOT) {
                if (freeSlots.isEmpty()) {
                    leftovers.add(outputStack);
                    continue;
                }
                int newSlot = (Integer)freeSlots.removeFirst();
                newStacks.put(newSlot, outputStack);
                continue;
            }
            int amount = outputStack.getAmount();
            int stackSize = outputStack.getType().getMaxStackSize();
            Iterator iterator = filledSlots.iterator();
            while (iterator.hasNext()) {
                int currentAdd;
                int filledAmount;
                int i = (Integer)iterator.next();
                if (amount <= 0) break;
                ItemStack filledItem = inventory.getItem(i);
                if (!SlimefunUtils.isItemSimilar(filledItem, outputStack, true, false) || (filledAmount = filledItem.getAmount()) + (currentAdd = addToStacks.getOrDefault(i, 0).intValue()) >= stackSize) continue;
                if (filledAmount + currentAdd + amount > stackSize) {
                    int diff = stackSize - filledAmount - currentAdd;
                    amount -= diff;
                    addToStacks.put(i, diff + currentAdd);
                    continue;
                }
                addToStacks.put(i, amount + currentAdd);
                amount = 0;
            }
            if (amount <= 0) continue;
            outputStack.setAmount(amount);
            if (freeSlots.isEmpty()) {
                leftovers.add(outputStack);
                continue;
            }
            int newSlot = (Integer)freeSlots.removeFirst();
            newStacks.put(newSlot, outputStack);
        }
        return new AbstractRecipeOutput.Inserter(inventory, addToStacks, newStacks, leftovers);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public String toString() {
        return "RecipeOutput { " + String.valueOf(this.items) + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeOutput output = (RecipeOutput)obj;
        return output.items.equals(this.items);
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject output = new JsonObject();
        JsonArray arr = new JsonArray();
        for (AbstractRecipeOutputItem item : this.items) {
            arr.add(item.serialize(context));
        }
        output.add("items", (JsonElement)arr);
        return output;
    }
}

