/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.MatchProcedure;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public class RecipeInput
extends AbstractRecipeInput {
    public static final AbstractRecipeInput EMPTY = new AbstractRecipeInput(){

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public void setWidth(int width) {
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void setHeight(int height) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public List<AbstractRecipeInputItem> getItems() {
            return Collections.emptyList();
        }

        @Override
        public void setItems(List<AbstractRecipeInputItem> items) {
        }

        @Override
        public MatchProcedure getMatchProcedure() {
            return MatchProcedure.EMPTY;
        }

        @Override
        public void setMatchProcedure(MatchProcedure matchProcedure) {
        }

        @Override
        public Optional<RecipeUtils.BoundingBox> getBoundingBox() {
            return Optional.empty();
        }

        @Override
        public String toString() {
            return "RInput { EMPTY }";
        }

        @Override
        public JsonElement serialize(JsonSerializationContext context) {
            return new JsonObject();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private List<AbstractRecipeInputItem> items;
    private MatchProcedure match;
    private int width;
    private int height;
    private Optional<RecipeUtils.BoundingBox> boundingBox;

    public RecipeInput(List<AbstractRecipeInputItem> items, MatchProcedure match, int width, int height) {
        this.items = items;
        this.match = match;
        this.width = width;
        this.height = height;
        this.saveBoundingBox();
    }

    public RecipeInput(List<AbstractRecipeInputItem> items, MatchProcedure match) {
        this.items = items;
        this.match = match;
        this.width = items.size();
        this.height = 1;
        this.saveBoundingBox();
    }

    public static RecipeInput fromItemStacks(ItemStack[] items, MatchProcedure match) {
        return new RecipeInput(Arrays.stream(items).map(item -> RecipeInputItem.fromItemStack(item)).toList(), match, 3, 3);
    }

    protected void saveBoundingBox() {
        if (this.match.recipeShouldSaveBoundingBox()) {
            this.boundingBox = Optional.of(RecipeUtils.calculateBoundingBox(this.items, this.width, this.height, item -> item.isEmpty()));
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.saveBoundingBox();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.saveBoundingBox();
    }

    @Override
    public List<AbstractRecipeInputItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public void setItems(List<AbstractRecipeInputItem> items) {
        this.items = items;
        this.saveBoundingBox();
    }

    public void setItems(List<AbstractRecipeInputItem> items, int width, int height) {
        this.items = items;
        this.width = width;
        this.height = height;
        this.saveBoundingBox();
    }

    @Override
    public MatchProcedure getMatchProcedure() {
        return this.match;
    }

    @Override
    public void setMatchProcedure(MatchProcedure match) {
        this.match = match;
        this.saveBoundingBox();
    }

    @Override
    public Optional<RecipeUtils.BoundingBox> getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public String toString() {
        return "RecipeInput { " + String.valueOf(this.items) + ", match=" + String.valueOf(this.match) + ", w=" + this.width + ", h=" + this.height + ", bb=" + String.valueOf(this.boundingBox) + " }";
    }

    @Override
    public boolean isEmpty() {
        if (this.boundingBox.isPresent()) {
            return this.boundingBox.get().getWidth() == 0 || this.boundingBox.get().getHeight() == 0;
        }
        return this.items.stream().allMatch(i -> i.isEmpty());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeInput input = (RecipeInput)obj;
        return input.items.equals(this.items) && input.width == this.width && input.height == this.height && input.match == this.match;
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        JsonPrimitive jsonTemplate;
        int current = 0;
        LinkedHashMap<AbstractRecipeInputItem, Integer> keys = new LinkedHashMap<AbstractRecipeInputItem, Integer>();
        ArrayList<String> template = new ArrayList<String>();
        for (int y = 0; y < this.height; ++y) {
            int i;
            char[] line = new char[this.width];
            Arrays.fill(line, ' ');
            for (int x = 0; x < this.width && (i = y * this.width + x) < this.items.size(); ++x) {
                int keyNum;
                AbstractRecipeInputItem inputItem = this.items.get(i);
                if (inputItem.isEmpty()) continue;
                if (keys.containsKey(inputItem)) {
                    keyNum = (Integer)keys.get(inputItem);
                } else {
                    keys.put(inputItem, current);
                    keyNum = current++;
                }
                line[x] = RecipeUtils.getKeyCharByNumber(keyNum);
            }
            template.add(new String(line));
        }
        JsonObject input = new JsonObject();
        if (template.size() == 1) {
            jsonTemplate = new JsonPrimitive((String)template.get(0));
        } else {
            JsonArray arr = new JsonArray();
            for (String line : template) {
                arr.add(line);
            }
            jsonTemplate = arr;
        }
        JsonObject key = new JsonObject();
        for (Map.Entry entry : keys.entrySet()) {
            key.add(String.valueOf(RecipeUtils.getKeyCharByNumber((Integer)entry.getValue())), ((AbstractRecipeInputItem)entry.getKey()).serialize(context));
        }
        input.add("items", (JsonElement)jsonTemplate);
        input.add("key", (JsonElement)key);
        input.addProperty("match", this.match.getKey().toString());
        return input;
    }
}

