/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes;

import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.Recipe;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputSlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputTag;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputSlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputTag;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.MatchProcedure;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public class RecipeBuilder {
    private final List<AbstractRecipeInputItem> inputItems = new ArrayList<AbstractRecipeInputItem>();
    private final List<AbstractRecipeOutputItem> outputItems = new ArrayList<AbstractRecipeOutputItem>();
    private final List<RecipeType> types = new ArrayList<RecipeType>();
    private final List<String> permissionNodes = new ArrayList<String>();
    private MatchProcedure match = null;
    private int width = 3;
    private int height = 3;
    private InputGenerator inputGenerator = RecipeInput::new;
    private Function<List<AbstractRecipeOutputItem>, AbstractRecipeOutput> outputGenerator = RecipeOutput::new;
    private Optional<Integer> energy = Optional.empty();
    private Optional<Integer> craftingTime = Optional.empty();
    private Optional<String> id = Optional.empty();
    private String filename = null;

    protected String getRecipeSubdirectory() {
        return "";
    }

    public Recipe build() {
        return new Recipe(this.id, Path.of(this.getRecipeSubdirectory(), this.filename).toString(), this.inputGenerator.create(this.inputItems, this.match, this.width, this.height), this.outputGenerator.apply(this.outputItems), this.types, this.energy, this.craftingTime, this.permissionNodes);
    }

    public RecipeBuilder i(@Nonnull AbstractRecipeInputItem i) {
        this.inputItems.add(i);
        return this;
    }

    public RecipeBuilder i(ItemStack item, int amount, int durabilityCost) {
        return this.i(RecipeInputItem.fromItemStack(item, amount, durabilityCost));
    }

    public RecipeBuilder i(ItemStack item, int amount) {
        return this.i(RecipeInputItem.fromItemStack(item, amount));
    }

    public RecipeBuilder i(ItemStack item) {
        return this.i(RecipeInputItem.fromItemStack(item));
    }

    public RecipeBuilder i(@Nonnull Material mat, int amount, int durabilityCost) {
        return this.i(new RecipeInputItemStack(mat, amount, durabilityCost));
    }

    public RecipeBuilder i(@Nonnull Material mat, int amount) {
        return this.i(new RecipeInputItemStack(mat, amount));
    }

    public RecipeBuilder i(@Nonnull Material mat) {
        return this.i(new RecipeInputItemStack(mat));
    }

    public RecipeBuilder i(@Nonnull String id, int amount, int durabilityCost) {
        return this.i(new RecipeInputSlimefunItem(id, amount, durabilityCost));
    }

    public RecipeBuilder i(@Nonnull String id, int amount) {
        return this.i(new RecipeInputSlimefunItem(id, amount));
    }

    public RecipeBuilder i(@Nonnull String id) {
        return this.i(new RecipeInputSlimefunItem(id));
    }

    public RecipeBuilder i(@Nonnull Tag<Material> id, int amount, int durabilityCost) {
        return this.i(new RecipeInputTag(id, amount, durabilityCost));
    }

    public RecipeBuilder i(@Nonnull Tag<Material> id, int amount) {
        return this.i(new RecipeInputTag(id, amount));
    }

    public RecipeBuilder i(@Nonnull Tag<Material> id) {
        return this.i(new RecipeInputTag(id));
    }

    public RecipeBuilder i(@Nonnull List<AbstractRecipeInputItem> group) {
        return this.i(new RecipeInputGroup(group));
    }

    public RecipeBuilder i(@Nonnull ItemStack[] items) {
        for (ItemStack item : items) {
            this.i(item);
        }
        return this;
    }

    public RecipeBuilder i() {
        return this.i(RecipeInputItem.EMPTY);
    }

    public RecipeBuilder i(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.i(RecipeInputItem.EMPTY);
        }
        return this;
    }

    public RecipeBuilder inputGenerator(@Nonnull InputGenerator generator) {
        this.inputGenerator = generator;
        return this;
    }

    public RecipeBuilder o(@Nonnull AbstractRecipeOutputItem o) {
        this.outputItems.add(o);
        return this;
    }

    public RecipeBuilder o(ItemStack item, int amount) {
        return this.o(RecipeOutputItem.fromItemStack(item, amount));
    }

    public RecipeBuilder o(ItemStack item) {
        return this.o(RecipeOutputItem.fromItemStack(item));
    }

    public RecipeBuilder o(@Nonnull Material item, int amount) {
        return this.o(new RecipeOutputItemStack(item, amount));
    }

    public RecipeBuilder o(@Nonnull Material item) {
        return this.o(new RecipeOutputItemStack(item));
    }

    public RecipeBuilder o(@Nonnull String id, int amount) {
        return this.o(new RecipeOutputSlimefunItem(id, amount));
    }

    public RecipeBuilder o(@Nonnull String id) {
        return this.o(new RecipeOutputSlimefunItem(id));
    }

    public RecipeBuilder o(@Nonnull Tag<Material> id, int amount) {
        return this.o(new RecipeOutputTag(id, amount));
    }

    public RecipeBuilder o(@Nonnull Tag<Material> id) {
        return this.o(new RecipeOutputTag(id));
    }

    public RecipeBuilder o() {
        return this.o(RecipeOutputItem.EMPTY);
    }

    public RecipeBuilder outputGenerator(@Nonnull Function<List<AbstractRecipeOutputItem>, AbstractRecipeOutput> generator) {
        this.outputGenerator = generator;
        return this;
    }

    public RecipeBuilder type(@Nonnull RecipeType t) {
        this.types.add(t);
        if (this.match == null) {
            this.match = t.getDefaultMatchProcedure();
        }
        return this;
    }

    public RecipeBuilder match(@Nonnull MatchProcedure match) {
        this.match = match;
        return this;
    }

    public RecipeBuilder dim(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public RecipeBuilder permission(@Nonnull String p) {
        this.permissionNodes.add(p);
        return this;
    }

    public RecipeBuilder energy(int energy) {
        this.energy = Optional.of(energy);
        return this;
    }

    public RecipeBuilder craftingTime(int ticks) {
        this.craftingTime = Optional.of(ticks);
        return this;
    }

    public RecipeBuilder id(@Nonnull String id) {
        this.id = Optional.of(id);
        if (this.filename == null) {
            this.filename = id;
        }
        return this;
    }

    public RecipeBuilder filename(@Nonnull String filename) {
        this.filename = filename;
        return this;
    }

    @FunctionalInterface
    static interface InputGenerator {
        public AbstractRecipeInput create(List<AbstractRecipeInputItem> var1, MatchProcedure var2, int var3, int var4);
    }
}

