/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.InputMatchResult;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.MatchProcedure;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class Recipe {
    private final Optional<String> id;
    private final String filename;
    private AbstractRecipeInput input;
    private AbstractRecipeOutput output;
    private final Set<RecipeType> types = new HashSet<RecipeType>();
    private Optional<Integer> energy;
    private Optional<Integer> craftingTime;
    private final Set<String> permissionNodes = new HashSet<String>();

    public Recipe(Optional<String> id, String filename, AbstractRecipeInput input, AbstractRecipeOutput output, Collection<RecipeType> types, Optional<Integer> energy, Optional<Integer> craftingTime, Collection<String> permissionNodes) {
        this.id = id;
        this.filename = filename;
        this.input = input;
        this.output = output;
        for (RecipeType type : types) {
            this.types.add(type);
        }
        this.energy = energy;
        this.craftingTime = craftingTime;
        for (String perm : permissionNodes) {
            this.permissionNodes.add(perm);
        }
    }

    public static Recipe fromItemStacks(String subdirectory, String id, ItemStack[] inputs, ItemStack[] outputs, RecipeType type, MatchProcedure match) {
        return new Recipe(Optional.of(id), Path.of(subdirectory, id.toLowerCase()).toString(), RecipeInput.fromItemStacks(inputs, match), RecipeOutput.fromItemStacks(outputs), List.of(type), Optional.empty(), Optional.empty(), List.of());
    }

    public static Recipe fromItemStacks(String subdirectory, String id, ItemStack[] inputs, ItemStack[] outputs, RecipeType type) {
        return Recipe.fromItemStacks(subdirectory, id, inputs, outputs, type, type.getDefaultMatchProcedure());
    }

    public static Recipe fromItemStacks(String id, ItemStack[] inputs, ItemStack[] outputs, RecipeType type, MatchProcedure match) {
        return new Recipe(Optional.of(id), id.toLowerCase(), RecipeInput.fromItemStacks(inputs, match), RecipeOutput.fromItemStacks(outputs), List.of(type), Optional.empty(), Optional.empty(), List.of());
    }

    public static Recipe fromItemStacks(String id, ItemStack[] inputs, ItemStack[] outputs, RecipeType type) {
        return Recipe.fromItemStacks(id, inputs, outputs, type, type.getDefaultMatchProcedure());
    }

    public static Recipe fromItemStacks(ItemStack[] inputs, ItemStack[] outputs, RecipeType type, MatchProcedure match) {
        return new Recipe(Optional.empty(), "other_recipes.json", RecipeInput.fromItemStacks(inputs, match), RecipeOutput.fromItemStacks(outputs), List.of(type), Optional.empty(), Optional.empty(), List.of());
    }

    public static Recipe fromItemStacks(ItemStack[] inputs, ItemStack[] outputs, RecipeType type) {
        return Recipe.fromItemStacks(inputs, outputs, type, type.getDefaultMatchProcedure());
    }

    public Optional<String> getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public AbstractRecipeInput getInput() {
        return this.input;
    }

    public void setInput(AbstractRecipeInput input) {
        this.input = input;
    }

    public AbstractRecipeOutput getOutput() {
        return this.output;
    }

    public void setOutput(AbstractRecipeOutput output) {
        this.output = output;
    }

    public Optional<Integer> getEnergy() {
        return this.energy;
    }

    public void setEnergy(Optional<Integer> energy) {
        this.energy = energy;
    }

    public Optional<Integer> getCraftingTime() {
        return this.craftingTime;
    }

    public void setCraftingTime(Optional<Integer> craftingTime) {
        this.craftingTime = craftingTime;
    }

    public Set<String> getPermissionNodes() {
        return this.permissionNodes;
    }

    public Set<RecipeType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public void addRecipeType(RecipeType type) {
        if (this.types.contains(type)) {
            return;
        }
        this.types.add(type);
        Slimefun.getRecipeService().addRecipeToType(this, type);
    }

    public RecipeMatchResult match(List<ItemStack> givenItems) {
        InputMatchResult result = this.getInput().match(givenItems);
        return new RecipeMatchResult(this, result);
    }

    public RecipeMatchResult matchAs(MatchProcedure match, List<ItemStack> givenItems) {
        InputMatchResult result = this.getInput().matchAs(match, givenItems);
        return new RecipeMatchResult(this, result);
    }

    @Deprecated
    public ItemStack[] getInputDisplay() {
        return this.input.getInputDisplay();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Recipe { ");
        builder.append(this.input.toString());
        builder.append(", ");
        builder.append(this.output.toString());
        if (!this.types.isEmpty()) {
            builder.append(", RecipeType(s) { ");
            builder.append(String.join((CharSequence)", ", this.types.stream().map(t -> t.toString()).toList()));
            builder.append(" }");
        }
        if (this.energy.isPresent()) {
            builder.append(", energy=");
            builder.append(this.energy.get());
        }
        if (this.craftingTime.isPresent()) {
            builder.append(", craftingTime=");
            builder.append(this.craftingTime.get());
        }
        if (!this.permissionNodes.isEmpty()) {
            builder.append(", Permission(s) { ");
            builder.append(String.join((CharSequence)", ", this.permissionNodes));
            builder.append(" }");
        }
        builder.append(" }");
        return builder.toString();
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject recipe = new JsonObject();
        if (this.id.isPresent()) {
            recipe.addProperty("id", this.id.get());
        }
        if (!this.input.isEmpty()) {
            recipe.add("input", this.input.serialize(context));
        }
        if (!this.output.isEmpty()) {
            recipe.add("output", this.output.serialize(context));
        }
        if (this.types.size() == 1) {
            recipe.addProperty("type", ((RecipeType)this.types.stream().findFirst().get()).toString());
        } else if (this.types.size() > 1) {
            JsonArray t = new JsonArray(this.types.size());
            for (RecipeType recipeType : this.types) {
                t.add(recipeType.getKey().toString());
            }
            recipe.add("type", (JsonElement)t);
        }
        if (this.energy.isPresent()) {
            recipe.addProperty("energy", (Number)this.energy.get());
        }
        if (this.craftingTime.isPresent()) {
            recipe.addProperty("crafting-time", (Number)this.craftingTime.get());
        }
        if (!this.permissionNodes.isEmpty()) {
            JsonArray p = new JsonArray(this.permissionNodes.size());
            for (String node : this.permissionNodes) {
                p.add(node);
            }
            recipe.add("permission-node", (JsonElement)p);
        }
        return recipe;
    }
}

