/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractRecipeOutput {
    @ParametersAreNonnullByDefault
    public abstract Inserter checkSpace(RecipeMatchResult var1, Inventory var2, int[] var3);

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<ItemStack> insertIntoInventory(RecipeMatchResult matchResult, Inventory inventory, int[] outputSlots) {
        Inserter inserter = this.checkSpace(matchResult, inventory, outputSlots);
        inserter.insert();
        return inserter.getLeftovers();
    }

    @Nonnull
    public abstract List<ItemStack> generateOutput(@Nonnull RecipeMatchResult var1);

    public abstract boolean isEmpty();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract JsonElement serialize(JsonSerializationContext var1);

    public static class Inserter {
        private final Inventory inv;
        private final Map<Integer, Integer> addToStacks;
        private final Map<Integer, ItemStack> newStacks;
        private final List<ItemStack> leftovers;

        public Inserter(Inventory inv, Map<Integer, Integer> addToStacks, Map<Integer, ItemStack> newStacks, List<ItemStack> leftovers) {
            this.inv = inv;
            this.addToStacks = addToStacks;
            this.newStacks = newStacks;
            this.leftovers = leftovers;
        }

        public Inserter(Inventory inv) {
            this.inv = inv;
            this.addToStacks = Collections.emptyMap();
            this.newStacks = Collections.emptyMap();
            this.leftovers = Collections.emptyList();
        }

        public void insert() {
            for (Map.Entry<Integer, Integer> entry : this.addToStacks.entrySet()) {
                ItemStack item = this.inv.getItem(entry.getKey().intValue());
                item.setAmount(item.getAmount() + entry.getValue());
            }
            for (Map.Entry<Integer, Integer> entry : this.newStacks.entrySet()) {
                this.inv.setItem(entry.getKey().intValue(), (ItemStack)entry.getValue());
            }
        }

        public List<ItemStack> getLeftovers() {
            return Collections.unmodifiableList(this.leftovers);
        }
    }
}

