/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public interface SlimefunAddon {
    @Nonnull
    public JavaPlugin getJavaPlugin();

    @Nullable
    public String getBugTrackerURL();

    @Nonnull
    default public String getName() {
        return this.getJavaPlugin().getName();
    }

    @Nonnull
    default public String getPluginVersion() {
        return this.getJavaPlugin().getDescription().getVersion();
    }

    @Nonnull
    default public Logger getLogger() {
        return this.getJavaPlugin().getLogger();
    }

    default public boolean hasDependency(@Nonnull String dependency) {
        Validate.notNull(dependency, "The dependency cannot be null");
        if (this.getJavaPlugin().getName().equalsIgnoreCase(dependency)) {
            return true;
        }
        PluginDescriptionFile description = this.getJavaPlugin().getDescription();
        return description.getDepend().contains(dependency) || description.getSoftDepend().contains(dependency);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public Set<String> getResourceRecipeFilenames() {
        URI resourceUri;
        URL resourceDir = this.getClass().getResource("/recipes");
        if (resourceDir == null) {
            return Collections.emptySet();
        }
        try {
            resourceUri = resourceDir.toURI();
        }
        catch (URISyntaxException e) {
            return Collections.emptySet();
        }
        if (!resourceUri.getScheme().equals("jar")) {
            return Collections.emptySet();
        }
        try (FileSystem fs = FileSystems.newFileSystem(resourceUri, Collections.emptyMap());){
            Set<String> set;
            block22: {
                Path recipeDir = fs.getPath("/recipes", new String[0]);
                Stream<Path> files = Files.walk(recipeDir, new FileVisitOption[0]);
                try {
                    Set<String> names;
                    set = names = files.filter(file -> file.toString().endsWith(".json")).map(file -> {
                        String filename = recipeDir.relativize((Path)file).toString();
                        return filename.substring(0, filename.length() - 5);
                    }).collect(Collectors.toSet());
                    if (files == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Set<String> set2 = Collections.emptySet();
                        if (fs != null) {
                            fs.close();
                        }
                        return set2;
                    }
                }
                files.close();
            }
            return set;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    default public void copyResourceRecipes(String subdirectory) {
        Set<String> existingRecipes = Slimefun.getRecipeService().getAllRecipeFilenames(subdirectory);
        Set<String> resourceNames = this.getResourceRecipeFilenames();
        resourceNames.removeIf(existingRecipes::contains);
        for (String name : resourceNames) {
            try {
                InputStream source = this.getClass().getResourceAsStream("/recipes/" + name + ".json");
                try {
                    Path dest = Path.of("plugins/Slimefun/recipes/", subdirectory, name + ".json");
                    Path parent = dest.getParent();
                    if (parent != null && !parent.toFile().exists()) {
                        parent.toFile().mkdirs();
                    }
                    Files.copy(source, dest, new CopyOption[0]);
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Couldn't copy recipes in resource file '" + name + "': " + e.getLocalizedMessage());
                throw new RuntimeException(e);
            }
        }
    }

    default public void copyResourceRecipes() {
        this.copyResourceRecipes("");
    }
}

