/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.biomes;

import com.google.gson.JsonElement;
import io.github.thebusybiscuit.slimefun4.api.exceptions.BiomeMapException;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeDataConverter;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeMapParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.plugin.java.JavaPlugin;

public class BiomeMap<T>
implements Keyed {
    private final Map<Biome, T> dataMap = new HashMap<Biome, T>();
    private final NamespacedKey namespacedKey;

    @ParametersAreNonnullByDefault
    public BiomeMap(NamespacedKey namespacedKey) {
        Validate.notNull(namespacedKey, "The key must not be null.");
        this.namespacedKey = namespacedKey;
    }

    @Nullable
    public T get(@Nonnull Biome biome) {
        Validate.notNull(biome, "The biome shall not be null.");
        return this.dataMap.get(biome);
    }

    @Nonnull
    public T getOrDefault(@Nonnull Biome biome, T defaultValue) {
        Validate.notNull(biome, "The biome should not be null.");
        return this.dataMap.getOrDefault(biome, defaultValue);
    }

    public boolean containsKey(@Nonnull Biome biome) {
        Validate.notNull(biome, "The biome must not be null.");
        return this.dataMap.containsKey(biome);
    }

    public boolean containsValue(@Nonnull T value) {
        Validate.notNull(value, "The value must not be null.");
        return this.dataMap.containsValue(value);
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    public boolean put(@Nonnull Biome biome, @Nonnull T value) {
        Validate.notNull(biome, "The biome should not be null.");
        Validate.notNull(value, "Values cannot be null.");
        return this.dataMap.put(biome, value) == null;
    }

    public void putAll(@Nonnull Map<Biome, T> map) {
        Validate.notNull(map, "The map should not be null.");
        this.dataMap.putAll(map);
    }

    public void putAll(@Nonnull BiomeMap<T> map) {
        Validate.notNull(map, "The map should not be null.");
        this.dataMap.putAll(map.dataMap);
    }

    public boolean remove(@Nonnull Biome biome) {
        Validate.notNull(biome, "The biome cannot be null.");
        return this.dataMap.remove(biome) != null;
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public String toString() {
        return "BiomeMap " + this.dataMap.toString();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static <T> BiomeMap<T> fromJson(NamespacedKey key, String json, BiomeDataConverter<T> valueConverter) throws BiomeMapException {
        BiomeMapParser<T> parser = new BiomeMapParser<T>(key, valueConverter);
        parser.read(json);
        return parser.buildBiomeMap();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static <T> BiomeMap<T> fromJson(NamespacedKey key, String json, BiomeDataConverter<T> valueConverter, boolean isLenient) throws BiomeMapException {
        BiomeMapParser<T> parser = new BiomeMapParser<T>(key, valueConverter);
        parser.setLenient(isLenient);
        parser.read(json);
        return parser.buildBiomeMap();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static <T> BiomeMap<T> fromResource(NamespacedKey key, JavaPlugin plugin, String path, BiomeDataConverter<T> valueConverter) throws BiomeMapException {
        BiomeMap<T> biomeMap;
        Validate.notNull(key, "The key shall not be null.");
        Validate.notNull(plugin, "The plugin shall not be null.");
        Validate.notNull(path, "The path should not be null!");
        BufferedReader reader = new BufferedReader(new InputStreamReader(plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));
        try {
            biomeMap = BiomeMap.fromJson(key, reader.lines().collect(Collectors.joining("")), valueConverter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException x) {
                throw new BiomeMapException(key, (Throwable)x);
            }
        }
        reader.close();
        return biomeMap;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static BiomeMap<Integer> getIntMapFromResource(NamespacedKey key, JavaPlugin plugin, String path) throws BiomeMapException {
        return BiomeMap.fromResource(key, plugin, path, JsonElement::getAsInt);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static BiomeMap<Long> getLongMapFromResource(NamespacedKey key, JavaPlugin plugin, String path) throws BiomeMapException {
        return BiomeMap.fromResource(key, plugin, path, JsonElement::getAsLong);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static BiomeMap<String> getStringMapFromResource(NamespacedKey key, JavaPlugin plugin, String path) throws BiomeMapException {
        return BiomeMap.fromResource(key, plugin, path, JsonElement::getAsString);
    }
}

