/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.operations;

import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

public class MiningOperation
implements MachineOperation {
    private final ItemStack result;
    private final int totalTicks;
    private int currentTicks = 0;

    public MiningOperation(@Nonnull ItemStack result, int totalTicks) {
        Validate.notNull(result, "The result cannot be null");
        Validate.isTrue(totalTicks >= 0, "The amount of total ticks must be a positive integer or zero, received: " + totalTicks);
        this.result = result;
        this.totalTicks = totalTicks;
    }

    @Override
    public void addProgress(int num) {
        Validate.isTrue(num > 0, "Progress must be positive.");
        this.currentTicks += num;
    }

    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public int getProgress() {
        return this.currentTicks;
    }

    @Override
    public int getTotalTicks() {
        return this.totalTicks;
    }
}

