/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.SlimefunCraftingListener;
import javax.annotation.Nonnull;
import org.bukkit.block.BrewingStand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class BrewingStandListener
implements SlimefunCraftingListener {
    public BrewingStandListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPreBrew(InventoryClickEvent e) {
        Inventory clickedInventory = e.getClickedInventory();
        Inventory topInventory = e.getView().getTopInventory();
        if (clickedInventory != null && topInventory.getType() == InventoryType.BREWING && topInventory.getHolder() instanceof BrewingStand) {
            if (e.getAction() == InventoryAction.HOTBAR_SWAP) {
                e.setCancelled(true);
                return;
            }
            if (clickedInventory.getType() == InventoryType.BREWING) {
                e.setCancelled(this.isUnallowed(SlimefunItem.getByItem(e.getCursor())));
            } else {
                e.setCancelled(this.isUnallowed(SlimefunItem.getByItem(e.getCurrentItem())));
            }
            if (e.getResult() == Event.Result.DENY) {
                Slimefun.getLocalization().sendMessage((CommandSender)((Player)e.getWhoClicked()), "brewing_stand.not-working", true);
            }
        }
    }

    @EventHandler
    public void hopperOnBrew(InventoryMoveItemEvent e) {
        if (e.getDestination().getType() == InventoryType.BREWING && this.isUnallowed(e.getItem())) {
            e.setCancelled(true);
        }
    }
}

