/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemFilter;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.ItemStack;

abstract class AbstractItemNetwork
extends Network {
    protected Map<Location, BlockFace> connectorCache = new HashMap<Location, BlockFace>();
    protected Map<Location, ItemFilter> filterCache = new HashMap<Location, ItemFilter>();

    protected AbstractItemNetwork(@Nonnull Location regulator) {
        super(Slimefun.getNetworkManager(), regulator);
    }

    protected Optional<Block> getAttachedBlock(@Nonnull Location l) {
        Block block;
        if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4) && (block = l.getBlock()).getType() == Material.PLAYER_WALL_HEAD) {
            BlockFace cached = this.connectorCache.get(l);
            if (cached != null) {
                return Optional.of(block.getRelative(cached));
            }
            BlockFace face = ((Directional)block.getBlockData()).getFacing().getOppositeFace();
            this.connectorCache.put(l, face);
            return Optional.of(block.getRelative(face));
        }
        return Optional.empty();
    }

    @Override
    public void markDirty(@Nonnull Location l) {
        this.markCargoNodeConfigurationDirty(l);
        super.markDirty(l);
    }

    public void markCargoNodeConfigurationDirty(@Nonnull Location node) {
        ItemFilter filter = this.filterCache.get(node);
        if (filter != null) {
            filter.markDirty();
        }
        this.connectorCache.remove(node);
    }

    @ParametersAreNonnullByDefault
    private void handleWithdraw(DirtyChestMenu menu, List<ItemStackAndInteger> items, Location l) {
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            this.filter(menu.getItemInSlot(slot), items, l);
        }
    }

    @ParametersAreNonnullByDefault
    private void filter(@Nullable ItemStack stack, List<ItemStackAndInteger> items, Location node) {
        if (stack != null && CargoUtils.matchesFilter(this, node.getBlock(), stack)) {
            boolean add = true;
            for (ItemStackAndInteger item : items) {
                if (!SlimefunUtils.isItemSimilar(stack, item.getItemStackWrapper(), true, false)) continue;
                add = false;
                item.add(stack.getAmount());
            }
            if (add) {
                items.add(new ItemStackAndInteger(stack, stack.getAmount()));
            }
        }
    }

    @Nonnull
    protected ItemFilter getItemFilter(@Nonnull Block node) {
        Location loc = node.getLocation();
        ItemFilter filter = this.filterCache.get(loc);
        if (filter == null) {
            ItemFilter newFilter = new ItemFilter(node);
            this.filterCache.put(loc, newFilter);
            return newFilter;
        }
        if (filter.isDirty()) {
            filter.update(node);
            return filter;
        }
        return filter;
    }
}

