/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.exceptions.PrematureCodeException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.WrongItemStackException;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemMetaSnapshot;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedItemFlag;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SlimefunItemStack
extends ItemStack {
    private String id;
    private ItemMetaSnapshot itemMetaSnapshot;
    private boolean locked = false;
    private String texture = null;

    public SlimefunItemStack(@Nonnull String id, @Nonnull ItemStack item) {
        super(item);
        Validate.notNull(id, "The Item id must never be null!");
        Validate.isTrue(id.equals(id.toUpperCase(Locale.ROOT)), "Slimefun Item Ids must be uppercase! (e.g. 'MY_ITEM_ID')");
        if (Slimefun.instance() == null) {
            throw new PrematureCodeException("A SlimefunItemStack must never be be created before your Plugin was enabled.");
        }
        this.id = id;
        ItemMeta meta = this.getItemMeta();
        Slimefun.getItemDataService().setItemData(meta, id);
        Slimefun.getItemTextureService().setTexture(meta, id);
        this.setItemMeta(meta);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull ItemStack item, @Nonnull Consumer<ItemMeta> consumer) {
        this(id, item);
        ItemMeta im = this.getItemMeta();
        consumer.accept(im);
        this.setItemMeta(im);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull Material type, @Nonnull Consumer<ItemMeta> consumer) {
        this(id, new ItemStack(type), consumer);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull Material type, @Nullable String name, @Nonnull Consumer<ItemMeta> consumer) {
        this(id, type, (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull ItemStack item, @Nullable String name, String ... lore) {
        this(id, item, (ItemMeta im) -> {
            if (name != null) {
                im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                im.setLore(lines);
            }
        });
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull Material type, @Nullable String name, String ... lore) {
        this(id, new ItemStack(type), name, lore);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull Material type, @Nonnull Color color, @Nullable String name, String ... lore) {
        this(id, type, (ItemMeta im) -> {
            if (name != null) {
                im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                im.setLore(lines);
            }
            if (im instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)im;
                leatherArmorMeta.setColor(color);
            }
            if (im instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)im;
                potionMeta.setColor(color);
            }
        });
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull Color color, @Nonnull PotionEffect effect, @Nullable String name, String ... lore) {
        this(id, Material.POTION, (ItemMeta im) -> {
            if (name != null) {
                im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                im.setLore(lines);
            }
            if (im instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)im;
                potionMeta.setColor(color);
                potionMeta.addCustomEffect(effect, true);
                if (effect.getType().equals(PotionEffectType.SATURATION)) {
                    im.addItemFlags(new ItemFlag[]{VersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }
            }
        });
    }

    public SlimefunItemStack(@Nonnull SlimefunItemStack item, int amount) {
        this(item.getItemId(), item);
        this.setAmount(amount);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull String texture, @Nullable String name, String ... lore) {
        this(id, SlimefunItemStack.getSkull(id, texture), name, lore);
        this.texture = SlimefunItemStack.getTexture(id, texture);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull HeadTexture head, @Nullable String name, String ... lore) {
        this(id, head.getTexture(), name, lore);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull String texture, @Nullable String name, @Nonnull Consumer<ItemMeta> consumer) {
        this(id, SlimefunItemStack.getSkull(id, texture), (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
        this.texture = SlimefunItemStack.getTexture(id, texture);
    }

    public SlimefunItemStack(@Nonnull String id, @Nonnull String texture, @Nonnull Consumer<ItemMeta> consumer) {
        this(id, SlimefunItemStack.getSkull(id, texture), consumer);
        this.texture = SlimefunItemStack.getTexture(id, texture);
    }

    @Nonnull
    public final String getItemId() {
        return this.id;
    }

    @Nullable
    public SlimefunItem getItem() {
        return SlimefunItem.getById(this.id);
    }

    @Nullable
    public <T extends SlimefunItem> T getItem(@Nonnull Class<T> type) {
        SlimefunItem item = this.getItem();
        return (T)(type.isInstance(item) ? (SlimefunItem)type.cast(item) : null);
    }

    @Nonnull
    public ItemMetaSnapshot getItemMetaSnapshot() {
        return this.itemMetaSnapshot;
    }

    public boolean setItemMeta(ItemMeta meta) {
        this.validate();
        this.itemMetaSnapshot = new ItemMetaSnapshot(meta);
        return super.setItemMeta(meta);
    }

    public void setType(Material type) {
        this.validate();
        super.setType(type);
    }

    public void setAmount(int amount) {
        this.validate();
        super.setAmount(amount);
    }

    private void validate() {
        if (this.locked) {
            throw new WrongItemStackException(this.id + " is not mutable.");
        }
    }

    public void lock() {
        this.locked = true;
    }

    @Nonnull
    public Optional<String> getSkullTexture() {
        return Optional.ofNullable(this.texture);
    }

    @Nullable
    public String getDisplayName() {
        if (this.itemMetaSnapshot == null) {
            return null;
        }
        return this.itemMetaSnapshot.getDisplayName().orElse(null);
    }

    @Nonnull
    private static ItemStack getSkull(@Nonnull String id, @Nonnull String texture) {
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        PlayerSkin skin = PlayerSkin.fromBase64(SlimefunItemStack.getTexture(id, texture));
        return PlayerHead.getItemStack(skin);
    }

    @Nonnull
    private static String getTexture(@Nonnull String id, @Nonnull String texture) {
        Validate.notNull(id, "The id cannot be null");
        Validate.notNull(texture, "The texture cannot be null");
        if (texture.startsWith("ey")) {
            return texture;
        }
        if (CommonPatterns.HEXADECIMAL.matcher(texture).matches()) {
            String value = "{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + texture + "\"}}}";
            return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("The provided texture for Item \"" + id + "\" does not seem to be a valid texture String!");
    }

    public ItemStack clone() {
        return new SlimefunItemStack(this.id, super.clone());
    }

    public String toString() {
        return "SlimefunItemStack (" + this.id + (String)(this.getAmount() > 1 ? " x " + this.getAmount() : "") + ")";
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

