/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedPotionEffectType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public final class TeleportationManager {
    private final int[] teleporterBorder = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] teleporterInventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final Set<UUID> teleporterUsers = new HashSet<UUID>();

    @ParametersAreNonnullByDefault
    public void openTeleporterGUI(Player p, UUID ownerUUID, Block b) {
        this.openTeleporterGUI(p, ownerUUID, b, Slimefun.getGPSNetwork().getNetworkComplexity(ownerUUID));
    }

    @ParametersAreNonnullByDefault
    public void openTeleporterGUI(Player p, UUID ownerUUID, Block b, int complexity) {
        if (this.teleporterUsers.add(p.getUniqueId())) {
            SoundEffect.TELEPORTATION_MANAGER_OPEN_GUI.playFor(p);
            PlayerProfile.fromUUID(ownerUUID, profile -> {
                ChestMenu menu = new ChestMenu("&3Teleporter");
                menu.addMenuCloseHandler(pl -> this.teleporterUsers.remove(pl.getUniqueId()));
                for (int slot : this.teleporterBorder) {
                    menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                }
                menu.addItem(4, CustomItemStack.create(HeadTexture.GLOBE_OVERWORLD.getAsItemStack(), String.valueOf(ChatColor.YELLOW) + Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.gui.title"), new String[0]));
                menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
                Location source = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 2.0, (double)b.getZ() + 0.5);
                int index = 0;
                for (Waypoint waypoint : profile.getWaypoints()) {
                    if (index >= this.teleporterInventory.length) break;
                    int slot = this.teleporterInventory[index];
                    Location l = waypoint.getLocation();
                    double time = NumberUtils.reparseDouble(0.5 * (double)this.getTeleportationTime(complexity, source, l));
                    String[] lore = new String[]{"", "&8\u21e8 &7" + Slimefun.getLocalization().getResourceString(p, "tooltips.world") + ": &f" + l.getWorld().getName(), "&8\u21e8 &7X: &f" + l.getX(), "&8\u21e8 &7Y: &f" + l.getY(), "&8\u21e8 &7Z: &f" + l.getZ(), "&8\u21e8 &7" + Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.gui.time") + ": &f" + time + "s", "", "&8\u21e8 &c" + Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.gui.tooltip")};
                    menu.addItem(slot, CustomItemStack.create(waypoint.getIcon(), waypoint.getName().replace("player:death ", ""), lore));
                    menu.addMenuClickHandler(slot, (pl, s, item, action) -> {
                        pl.closeInventory();
                        this.teleport(pl.getUniqueId(), complexity, source, l, false);
                        return false;
                    });
                    ++index;
                }
                Slimefun.runSync(() -> menu.open(p));
            });
        }
    }

    @ParametersAreNonnullByDefault
    public void teleport(UUID uuid, int complexity, Location source, Location destination, boolean resistance) {
        this.teleporterUsers.add(uuid);
        int time = this.getTeleportationTime(complexity, source, destination);
        int speed = Math.max(1, 100 / time);
        this.updateProgress(uuid, speed, 0, source, destination, resistance);
    }

    public int getTeleportationTime(int complexity, @Nonnull Location source, @Nonnull Location destination) {
        Validate.notNull(source, "Source cannot be null");
        Validate.notNull(source, "Destination cannot be null");
        if (complexity < 100) {
            return 100;
        }
        int speed = 50000 + complexity * complexity;
        int unsafeTime = Math.min(4 * this.distanceSquared(source, destination) / speed, 40);
        return Math.max(1, unsafeTime);
    }

    @ParametersAreNonnullByDefault
    private int distanceSquared(Location source, Location destination) {
        if (source.getWorld().getUID().equals(destination.getWorld().getUID())) {
            int distance = (int)source.distanceSquared(destination);
            return Math.min(distance, 100000000);
        }
        return 150000000;
    }

    private boolean isValid(@Nullable Player p, @Nonnull Location source) {
        return p != null && p.isValid() && p.getWorld().getUID().equals(source.getWorld().getUID()) && p.getLocation().distanceSquared(source) < 2.0;
    }

    private void cancel(@Nonnull UUID uuid, @Nullable Player p) {
        this.teleporterUsers.remove(uuid);
        if (p != null) {
            p.sendTitle(ChatColors.color(Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.cancelled")), ChatColors.color("&c&k40&f&c%"), 20, 60, 20);
        }
    }

    @ParametersAreNonnullByDefault
    private void updateProgress(UUID uuid, int speed, int progress, Location source, Location destination, boolean resistance) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (this.isValid(p, source)) {
            if (progress > 99) {
                p.sendTitle(ChatColors.color(Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.teleported")), ChatColors.color("&b100%"), 20, 60, 20);
                PaperLib.teleportAsync((Entity)p, destination).thenAccept(success -> this.onTeleport(p, destination, (boolean)success, resistance));
            } else {
                p.sendTitle(ChatColors.color(Slimefun.getLocalization().getMessage(p, "machines.TELEPORTER.teleporting")), ChatColors.color("&b" + progress + "%"), 0, 60, 0);
                source.getWorld().spawnParticle(Particle.PORTAL, source, progress * 2, (double)0.2f, (double)0.8f, (double)0.2f);
                SoundEffect.TELEPORT_UPDATE_SOUND.playFor(p);
                Slimefun.runSync(() -> this.updateProgress(uuid, speed, progress + speed, source, destination, resistance), 10L);
            }
        } else {
            this.cancel(uuid, p);
        }
    }

    @ParametersAreNonnullByDefault
    private void onTeleport(Player p, Location destination, boolean success, boolean resistance) {
        Slimefun.runSync(() -> {
            if (success) {
                if (resistance) {
                    p.addPotionEffect(new PotionEffect(VersionedPotionEffectType.RESISTANCE, 600, 20));
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.TELEPORTER.invulnerability");
                }
                Location loc = new Location(destination.getWorld(), destination.getX(), destination.getY() + 1.0, destination.getZ());
                destination.getWorld().spawnParticle(Particle.PORTAL, loc, 200, (double)0.2f, (double)0.8f, (double)0.2f);
                SoundEffect.TELEPORT_SOUND.playFor(p);
                this.teleporterUsers.remove(p.getUniqueId());
            } else {
                this.cancel(p.getUniqueId(), p);
            }
        });
    }
}

