/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class GEOResourceGenerationEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final World world;
    private final Biome biome;
    private final GEOResource resource;
    private final int x;
    private final int z;
    private int value;

    @ParametersAreNonnullByDefault
    public GEOResourceGenerationEvent(World world, Biome biome, int x, int z, GEOResource resource, int value) {
        this.world = world;
        this.biome = biome;
        this.resource = resource;
        this.x = x;
        this.z = z;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("You cannot set a GEO-Resource supply to a negative value.");
        }
        this.value = value;
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Nonnull
    public GEOResource getResource() {
        return this.resource;
    }

    public int getChunkX() {
        return this.x;
    }

    public int getChunkZ() {
        return this.z;
    }

    @Nonnull
    public World.Environment getEnvironment() {
        return this.world.getEnvironment();
    }

    @Nonnull
    public Biome getBiome() {
        return this.biome;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return GEOResourceGenerationEvent.getHandlerList();
    }
}

