/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricsService {
    private static final String API_URL = "https://api.github.com/";
    private static final String REPO_NAME = "MetricsModule2";
    private static final String JAR_NAME = "MetricsModule";
    private static final String RELEASES_URL = "https://api.github.com/repos/Slimefun/MetricsModule2/releases/latest";
    private static final String DOWNLOAD_URL = "https://github.com/Slimefun/MetricsModule2/releases/download";
    private final Slimefun plugin;
    private final File parentFolder;
    private final File metricsModuleFile;
    private final HttpClient client = HttpClient.newHttpClient();
    private URLClassLoader moduleClassLoader;
    private String metricVersion = null;
    private boolean hasDownloadedUpdate = false;

    public MetricsService(@Nonnull Slimefun plugin) {
        this.plugin = plugin;
        this.parentFolder = new File(plugin.getDataFolder(), "cache" + File.separatorChar + "modules");
        if (!this.parentFolder.exists()) {
            this.parentFolder.mkdirs();
        }
        this.metricsModuleFile = new File(this.parentFolder, "MetricsModule.jar");
    }

    public void start() {
        if (!this.metricsModuleFile.exists()) {
            this.plugin.getLogger().info("MetricsModule does not exist, downloading...");
            if (!this.download(this.getLatestVersion())) {
                this.plugin.getLogger().warning("Failed to start metrics as the file could not be downloaded.");
                return;
            }
        }
        try {
            this.moduleClassLoader = URLClassLoader.newInstance(new URL[]{this.metricsModuleFile.toURI().toURL()}, this.plugin.getClass().getClassLoader());
            Class<?> metricsClass = this.moduleClassLoader.loadClass("dev.walshy.sfmetrics.MetricsModule");
            this.metricVersion = metricsClass.getPackage().getImplementationVersion();
            if (!this.hasDownloadedUpdate && this.hasAutoUpdates() && this.checkForUpdate(this.metricVersion)) {
                this.plugin.getLogger().info("Cleaned up, now re-loading Metrics-Module!");
                this.start();
                return;
            }
            Method start = metricsClass.getDeclaredMethod("start", new Class[0]);
            String version = metricsClass.getPackage().getImplementationVersion();
            Slimefun.runSync(() -> {
                try {
                    start.invoke(null, new Object[0]);
                    this.plugin.getLogger().info("Metrics build #" + version + " started.");
                }
                catch (InvocationTargetException e) {
                    this.plugin.getLogger().log(Level.WARNING, "An exception was thrown while starting the metrics module", e.getCause());
                }
                catch (Exception | LinkageError e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to start metrics.", e);
                }
            });
        }
        catch (Exception | LinkageError e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load the metrics module. Maybe the jar is corrupt?", e);
        }
    }

    public void cleanUp() {
        try {
            if (this.moduleClassLoader != null) {
                this.moduleClassLoader.close();
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not clean up module class loader. Some memory may have been leaked.");
        }
    }

    public boolean checkForUpdate(@Nullable String currentVersion) {
        if (currentVersion == null || !CommonPatterns.NUMERIC.matcher(currentVersion).matches()) {
            return false;
        }
        int latest = this.getLatestVersion();
        if (latest > Integer.parseInt(currentVersion)) {
            return this.download(latest);
        }
        return false;
    }

    private int getLatestVersion() {
        try {
            HttpResponse<String> response = this.client.send(this.buildBaseRequest(URI.create(RELEASES_URL)), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                return -1;
            }
            JsonElement element = JsonParser.parseString((String)response.body());
            return element.getAsJsonObject().get("tag_name").getAsInt();
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to fetch latest builds for Metrics: {0}", e.getMessage());
            return -1;
        }
    }

    private boolean download(int version) {
        File file = new File(this.parentFolder, "Metrics-" + version + ".jar");
        try {
            HttpResponse<Path> response;
            this.plugin.getLogger().log(Level.INFO, "# Starting download of MetricsModule build: #{0}", version);
            if (file.exists()) {
                Files.delete(file.toPath());
            }
            if ((response = this.client.send(this.buildBaseRequest(URI.create("https://github.com/Slimefun/MetricsModule2/releases/download/" + version + "/MetricsModule.jar")), this.downloadMonitor(HttpResponse.BodyHandlers.ofFile(file.toPath())))).statusCode() >= 200 && response.statusCode() < 300) {
                this.plugin.getLogger().log(Level.INFO, "Successfully downloaded {0} build: #{1}", new Object[]{JAR_NAME, version});
                this.cleanUp();
                Files.move(file.toPath(), this.metricsModuleFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.metricVersion = String.valueOf(version);
                this.hasDownloadedUpdate = true;
                return true;
            }
        }
        catch (JsonParseException | InterruptedException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to fetch the latest jar file from the builds page. Perhaps GitHub is down? Response: {0}", e.getMessage());
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to replace the old metric file with the new one. Please do this manually! Error: {0}", e.getMessage());
        }
        return false;
    }

    @Nullable
    public String getVersion() {
        return this.metricVersion;
    }

    public boolean hasAutoUpdates() {
        return Slimefun.instance().getConfig().getBoolean("metrics.auto-update");
    }

    private HttpRequest buildBaseRequest(@Nonnull URI uri) {
        return HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(5L)).header("User-Agent", "MetricsModule Auto-Updater").header("Accept", "application/vnd.github.v3+json").build();
    }

    private <T> HttpResponse.BodyHandler<T> downloadMonitor(final HttpResponse.BodyHandler<T> h) {
        return info -> new HttpResponse.BodySubscriber<T>(){
            private HttpResponse.BodySubscriber<T> delegateSubscriber;
            private int lastPercentPosted;
            private long bytesWritten;
            {
                this.delegateSubscriber = h.apply(info);
                this.lastPercentPosted = 0;
                this.bytesWritten = 0L;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.delegateSubscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(List<ByteBuffer> item) {
                this.bytesWritten += item.stream().mapToLong(Buffer::capacity).sum();
                long totalBytes = info.headers().firstValue("Content-Length").map(Long::parseLong).orElse(-1L);
                int percent = (int)(20L * Math.round((double)this.bytesWritten / (double)totalBytes * 100.0 / 20.0));
                if (percent != 0 && percent != this.lastPercentPosted) {
                    MetricsService.this.plugin.getLogger().info("# Downloading... " + percent + "% (" + this.bytesWritten + "/" + totalBytes + " bytes)");
                    this.lastPercentPosted = percent;
                }
                this.delegateSubscriber.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.delegateSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.delegateSubscriber.onComplete();
            }

            @Override
            public CompletionStage<T> getBody() {
                return this.delegateSubscriber.getBody();
            }
        };
    }
}

